<?php


return  
    [
        'model' => [
            'model' => \Order\Eee\Models\Product::class,
            'repository' => \Order\Eee\Repositories\Eloquent\ProductRepository::class,
            'table' => 'products',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'createdat', 'updated_at'],
            'appends' => [],
            'fillable' => ['id',  'company_id',  'seller_company_id',  'product_id',  'subscription_id',  'quantity',  'repeat_interval',  'scheduler_id',  'notification_schedule_id',  'start_date',  'end_date',  'delivey_date',  'skiped_date',  'notification_date',  'status',  'deleted_at',  'created_at',  'updated_at'],
            'translatables' => [],
            'upload_folder' => 'eee/product',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            "company_id" => [
                "key" => "company_id", 
                "type" => "text", 
                "label" => 'eee::product.label.company_id', 
                'sort' => true,
                'roles' => [],
            ],
            "seller_company_id" => [
                "key" => "seller_company_id", 
                "type" => "text", 
                "label" => 'eee::product.label.seller_company_id', 
                'sort' => true,
                'roles' => [],
            ],
            "product_id" => [
                "key" => "product_id", 
                "type" => "text", 
                "label" => 'eee::product.label.product_id', 
                'sort' => true,
                'roles' => [],
            ],
            "subscription_id" => [
                "key" => "subscription_id", 
                "type" => "text", 
                "label" => 'eee::product.label.subscription_id', 
                'sort' => true,
                'roles' => [],
            ],
            "quantity" => [
                "key" => "quantity", 
                "type" => "text", 
                "label" => 'eee::product.label.quantity', 
                'sort' => true,
                'roles' => [],
            ],
            "repeat_interval" => [
                "key" => "repeat_interval", 
                "type" => "text", 
                "label" => 'eee::product.label.repeat_interval', 
                'sort' => true,
                'roles' => [],
            ],
            "scheduler_id" => [
                "key" => "scheduler_id", 
                "type" => "text", 
                "label" => 'eee::product.label.scheduler_id', 
                'sort' => true,
                'roles' => [],
            ],
            "notification_schedule_id" => [
                "key" => "notification_schedule_id", 
                "type" => "text", 
                "label" => 'eee::product.label.notification_schedule_id', 
                'sort' => true,
                'roles' => [],
            ],
            "start_date" => [
                "key" => "start_date", 
                "type" => "text", 
                "label" => 'eee::product.label.start_date', 
                'sort' => true,
                'roles' => [],
            ],
            "end_date" => [
                "key" => "end_date", 
                "type" => "text", 
                "label" => 'eee::product.label.end_date', 
                'sort' => true,
                'roles' => [],
            ],
            "delivey_date" => [
                "key" => "delivey_date", 
                "type" => "text", 
                "label" => 'eee::product.label.delivey_date', 
                'sort' => true,
                'roles' => [],
            ],
            "skiped_date" => [
                "key" => "skiped_date", 
                "type" => "text", 
                "label" => 'eee::product.label.skiped_date', 
                'sort' => true,
                'roles' => [],
            ],
            "notification_date" => [
                "key" => "notification_date", 
                "type" => "text", 
                "label" => 'eee::product.label.notification_date', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            'company_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::product.label.company_id',
                "placeholder" => 'eee::product.placeholder.company_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'seller_company_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::product.label.seller_company_id',
                "placeholder" => 'eee::product.placeholder.seller_company_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'product_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::product.label.product_id',
                "placeholder" => 'eee::product.placeholder.product_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'subscription_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::product.label.subscription_id',
                "placeholder" => 'eee::product.placeholder.subscription_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'quantity' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::product.label.quantity',
                "placeholder" => 'eee::product.placeholder.quantity',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'repeat_interval' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'eee::product.label.repeat_interval',
                "placeholder" => 'eee::product.placeholder.repeat_interval',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'scheduler_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::product.label.scheduler_id',
                "placeholder" => 'eee::product.placeholder.scheduler_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'notification_schedule_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => 'eee::product.label.notification_schedule_id',
                "placeholder" => 'eee::product.placeholder.notification_schedule_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'start_date' => [
                "element" => 'date_picker',
                "type" => 'date_picker',
                "label" => 'eee::product.label.start_date',
                "placeholder" => 'eee::product.placeholder.start_date',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'end_date' => [
                "element" => 'date_picker',
                "type" => 'date_picker',
                "label" => 'eee::product.label.end_date',
                "placeholder" => 'eee::product.placeholder.end_date',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'delivey_date' => [
                "element" => 'date_picker',
                "type" => 'date_picker',
                "label" => 'eee::product.label.delivey_date',
                "placeholder" => 'eee::product.placeholder.delivey_date',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'skiped_date' => [
                "element" => 'date_picker',
                "type" => 'date_picker',
                "label" => 'eee::product.label.skiped_date',
                "placeholder" => 'eee::product.placeholder.skiped_date',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'notification_date' => [
                "element" => 'date_picker',
                "type" => 'date_picker',
                "label" => 'eee::product.label.notification_date',
                "placeholder" => 'eee::product.placeholder.notification_date',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'eee/product/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'eee/product/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'eee/product',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'eee/product',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'eee/product',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'eee/product',
                'method' => 'DELETE',
            ],
        ],
        'order' => [
            'created_at' => 'eee::product.label.created_at',
            'name' => 'eee::product.label.name',
            'status' => 'eee::product.label.status',
        ],
        'groups' => [
            'main' => 'eee::product.groups.main',
            'details' => 'eee::product.groups.details',
            'images' => 'eee::product.groups.images',
            'settings' => 'eee::product.groups.settings',
        ],
        'controller' => [
            'provider' => 'Order',
            'package' => 'Eee',
            'module' => 'Product',
        ],
    ];
