<?php

namespace Litecms\Newsletter\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class NewsletterTransformer extends TransformerAbstract
{
    public function transform(\Litecms\Newsletter\Models\Newsletter $newsletter)
    {
        return [
            'id'                => $newsletter->getRouteKey(),
            'key'               => [
                'public'    => $newsletter->getPublicKey(),
                'route'     => $newsletter->getRouteKey(),
            ], 
            'id'                => $newsletter->id,
            'name'              => $newsletter->name,
            'email'             => $newsletter->email,
            'phone'             => $newsletter->phone,
            'slug'              => $newsletter->slug,
            'user_id'           => $newsletter->user_id,
            'user_type'         => $newsletter->user_type,
            'upload_folder'     => $newsletter->upload_folder,
            'deleted_at'        => $newsletter->deleted_at,
            'created_at'        => $newsletter->created_at,
            'updated_at'        => $newsletter->updated_at,
            'url'               => [
                'public'    => trans_url('newsletter/'.$newsletter->getPublicKey()),
                'user'      => guard_url('newsletter/newsletter/'.$newsletter->getRouteKey()),
            ], 
            'status'            => trans('app.'.$newsletter->status),
            'created_at'        => format_date($newsletter->created_at),
            'updated_at'        => format_date($newsletter->updated_at),
        ];
    }
}