<?php

namespace Litecms\Newsletter\Providers;

use Illuminate\Support\ServiceProvider;

class NewsletterServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'newsletter');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'newsletter');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('litecms.newsletter', function ($app) {
            return $this->app->make('Litecms\Newsletter\Newsletter');
        });

                // Bind Newsletter to repository
        $this->app->bind(
            'Litecms\Newsletter\Interfaces\NewsletterRepositoryInterface',
            \Litecms\Newsletter\Repositories\Eloquent\NewsletterRepository::class
        );

        $this->app->register(\Litecms\Newsletter\Providers\AuthServiceProvider::class);
        
        $this->app->register(\Litecms\Newsletter\Providers\RouteServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.newsletter'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('litecms/newsletter.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/newsletter')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/newsletter')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
