<?php

namespace Litecms\Newsletter\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\Newsletter\Models\Newsletter;

class NewsletterPolicy
{

    /**
     * Determine if the given user can view the newsletter.
     *
     * @param UserPolicy $user
     * @param Newsletter $newsletter
     *
     * @return bool
     */
    public function view(UserPolicy $user, Newsletter $newsletter)
    {
        if ($user->canDo('newsletter.newsletter.view') && $user->isAdmin()) {
            return true;
        }

        return $newsletter->user_id == user_id() && $newsletter->user_type == user_type();
    }

    /**
     * Determine if the given user can create a newsletter.
     *
     * @param UserPolicy $user
     * @param Newsletter $newsletter
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('newsletter.newsletter.create');
    }

    /**
     * Determine if the given user can update the given newsletter.
     *
     * @param UserPolicy $user
     * @param Newsletter $newsletter
     *
     * @return bool
     */
    public function update(UserPolicy $user, Newsletter $newsletter)
    {
        if ($user->canDo('newsletter.newsletter.edit') && $user->isAdmin()) {
            return true;
        }

        return $newsletter->user_id == user_id() && $newsletter->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given newsletter.
     *
     * @param UserPolicy $user
     * @param Newsletter $newsletter
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Newsletter $newsletter)
    {
        return $newsletter->user_id == user_id() && $newsletter->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given newsletter.
     *
     * @param UserPolicy $user
     * @param Newsletter $newsletter
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Newsletter $newsletter)
    {
        if ($user->canDo('newsletter.newsletter.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given newsletter.
     *
     * @param UserPolicy $user
     * @param Newsletter $newsletter
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Newsletter $newsletter)
    {
        if ($user->canDo('newsletter.newsletter.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
