<?php

namespace Litecms\Newsletter\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Litecms\Newsletter\Interfaces\NewsletterRepositoryInterface;

class NewsletterPublicController extends BaseController
{
    // use NewsletterWorkflow;

    /**
     * Constructor.
     *
     * @param type \Litecms\Newsletter\Interfaces\NewsletterRepositoryInterface $newsletter
     *
     * @return type
     */
    public function __construct(NewsletterRepositoryInterface $newsletter)
    {
        $this->repository = $newsletter;
        parent::__construct();
    }

    /**
     * Show newsletter's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $newsletters = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$newsletter::$newsletter.names'))
            ->view('$newsletter::public.newsletter.index')
            ->data(compact('$newsletters'))
            ->output();
    }

    /**
     * Show newsletter's list based on a type.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function list($type = null)
    {
        $newsletters = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$newsletter::$newsletter.names'))
            ->view('$newsletter::public.newsletter.index')
            ->data(compact('$newsletters'))
            ->output();
    }

    /**
     * Show newsletter.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $newsletter = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->title($$newsletter->name . trans('$newsletter::$newsletter.name'))
            ->view('$newsletter::public.newsletter.show')
            ->data(compact('$newsletter'))
            ->output();
    }

}
