<?php

namespace Litecms\Mcq\Workflow;

use Litecms\Mcq\Models\Mcq;
use Validator;

class McqValidator
{

    /**
     * Determine if the given mcq is valid for complete status.
     *
     * @param Mcq $mcq
     *
     * @return bool / Validator
     */
    public function complete(Mcq $mcq)
    {
        return Validator::make($mcq->toArray(), [
            'title' => 'required|min:15',
        ]);
    }

    /**
     * Determine if the given mcq is valid for verify status.
     *
     * @param Mcq $mcq
     *
     * @return bool / Validator
     */
    public function verify(Mcq $mcq)
    {
        return Validator::make($mcq->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:complete',
        ]);
    }

    /**
     * Determine if the given mcq is valid for approve status.
     *
     * @param Mcq $mcq
     *
     * @return bool / Validator
     */
    public function approve(Mcq $mcq)
    {
        return Validator::make($mcq->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:verify',
        ]);

    }

    /**
     * Determine if the given mcq is valid for publish status.
     *
     * @param Mcq $mcq
     *
     * @return bool / Validator
     */
    public function publish(Mcq $mcq)
    {
        return Validator::make($mcq->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,archive,unpublish',
        ]);

    }

    /**
     * Determine if the given mcq is valid for archive status.
     *
     * @param Mcq $mcq
     *
     * @return bool / Validator
     */
    public function archive(Mcq $mcq)
    {
        return Validator::make($mcq->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,publish,unpublish',
        ]);

    }

    /**
     * Determine if the given mcq is valid for unpublish status.
     *
     * @param Mcq $mcq
     *
     * @return bool / Validator
     */
    public function unpublish(Mcq $mcq)
    {
        return Validator::make($mcq->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:publish',
        ]);

    }
}
