<?php

namespace Litecms\Mcq\Workflow;

use Litecms\Mcq\Models\Mcq;
use Litecms\Mcq\Notifications\McqWorkflow as McqNotifyer;
use Notification;

class McqNotification
{

    /**
     * Send the notification to the users after complete.
     *
     * @param Mcq $mcq
     *
     * @return void
     */
    public function complete(Mcq $mcq)
    {
        return Notification::send($mcq->user, new McqNotifyer($mcq, 'complete'));;
    }

    /**
     * Send the notification to the users after verify.
     *
     * @param Mcq $mcq
     *
     * @return void
     */
    public function verify(Mcq $mcq)
    {
        return Notification::send($mcq->user, new McqNotifyer($mcq, 'verify'));;
    }

    /**
     * Send the notification to the users after approve.
     *
     * @param Mcq $mcq
     *
     * @return void
     */
    public function approve(Mcq $mcq)
    {
        return Notification::send($mcq->user, new McqNotifyer($mcq, 'approve'));;

    }

    /**
     * Send the notification to the users after publish.
     *
     * @param Mcq $mcq
     *
     * @return void
     */
    public function publish(Mcq $mcq)
    {
        return Notification::send($mcq->user, new McqNotifyer($mcq, 'publish'));;
    }

    /**
     * Send the notification to the users after archive.
     *
     * @param Mcq $mcq
     *
     * @return void
     */
    public function archive(Mcq $mcq)
    {
        return Notification::send($mcq->user, new McqNotifyer($mcq, 'archive'));;

    }

    /**
     * Send the notification to the users after unpublish.
     *
     * @param Mcq $mcq
     *
     * @return void
     */
    public function unpublish(Mcq $mcq)
    {
        return Notification::send($mcq->user, new McqNotifyer($mcq, 'unpublish'));;

    }
}
