<?php

namespace Litecms\Mcq\Workflow;

use Exception;
use Litepie\Workflow\Exceptions\WorkflowActionNotPerformedException;

use Litecms\Mcq\Models\Mcq;

class McqAction
{
    /**
     * Perform the complete action.
     *
     * @param Mcq $mcq
     *
     * @return Mcq
     */
    public function complete(Mcq $mcq)
    {
        try {
            $mcq->status = 'complete';
            return $mcq->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the verify action.
     *
     * @param Mcq $mcq
     *
     * @return Mcq
     */public function verify(Mcq $mcq)
    {
        try {
            $mcq->status = 'verify';
            return $mcq->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the approve action.
     *
     * @param Mcq $mcq
     *
     * @return Mcq
     */public function approve(Mcq $mcq)
    {
        try {
            $mcq->status = 'approve';
            return $mcq->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the publish action.
     *
     * @param Mcq $mcq
     *
     * @return Mcq
     */public function publish(Mcq $mcq)
    {
        try {
            $mcq->status = 'publish';
            return $mcq->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the archive action.
     *
     * @param Mcq $mcq
     *
     * @return Mcq
     */
    public function archive(Mcq $mcq)
    {
        try {
            $mcq->status = 'archive';
            return $mcq->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the unpublish action.
     *
     * @param Mcq $mcq
     *
     * @return Mcq
     */
    public function unpublish(Mcq $mcq)
    {
        try {
            $mcq->status = 'unpublish';
            return $mcq->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }
}
