<?php

namespace Litecms\Mcq\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class McqTransformer extends TransformerAbstract
{
    public function transform(\Litecms\Mcq\Models\Mcq $mcq)
    {
        return [
            'id'                => $mcq->getRouteKey(),
            'key'               => [
                'public'    => $mcq->getPublicKey(),
                'route'     => $mcq->getRouteKey(),
            ], 
            'question'          => $mcq->question,
            'answer'            => $mcq->answer,
            'url'               => [
                'public'    => trans_url('mcq/'.$mcq->getPublicKey()),
                'user'      => guard_url('mcq/mcq/'.$mcq->getRouteKey()),
            ], 
            'status'            => trans('app.'.$mcq->status),
            'created_at'        => format_date($mcq->created_at),
            'updated_at'        => format_date($mcq->updated_at),
        ];
    }
}