<?php

namespace Litecms\Mcq\Providers;

use Illuminate\Support\ServiceProvider;

class McqServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'mcq');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'mcq');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('litecms.mcq', function ($app) {
            return $this->app->make('Litecms\Mcq\Mcq');
        });

                // Bind Mcq to repository
        $this->app->bind(
            'Litecms\Mcq\Interfaces\McqRepositoryInterface',
            \Litecms\Mcq\Repositories\Eloquent\McqRepository::class
        );

        $this->app->register(\Litecms\Mcq\Providers\AuthServiceProvider::class);
        
        $this->app->register(\Litecms\Mcq\Providers\RouteServiceProvider::class);
                $this->app->register(\Litecms\Mcq\Providers\WorkflowServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.mcq'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('litecms/mcq.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/mcq')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/mcq')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
