<?php

namespace Litecms\Mcq\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\Mcq\Models\Mcq;

class McqPolicy
{

    /**
     * Determine if the given user can view the mcq.
     *
     * @param UserPolicy $user
     * @param Mcq $mcq
     *
     * @return bool
     */
    public function view(UserPolicy $user, Mcq $mcq)
    {
        if ($user->canDo('mcq.mcq.view') && $user->isAdmin()) {
            return true;
        }

        return $mcq->user_id == user_id() && $mcq->user_type == user_type();
    }

    /**
     * Determine if the given user can create a mcq.
     *
     * @param UserPolicy $user
     * @param Mcq $mcq
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('mcq.mcq.create');
    }

    /**
     * Determine if the given user can update the given mcq.
     *
     * @param UserPolicy $user
     * @param Mcq $mcq
     *
     * @return bool
     */
    public function update(UserPolicy $user, Mcq $mcq)
    {
        if ($user->canDo('mcq.mcq.edit') && $user->isAdmin()) {
            return true;
        }

        return $mcq->user_id == user_id() && $mcq->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given mcq.
     *
     * @param UserPolicy $user
     * @param Mcq $mcq
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Mcq $mcq)
    {
        return $mcq->user_id == user_id() && $mcq->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given mcq.
     *
     * @param UserPolicy $user
     * @param Mcq $mcq
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Mcq $mcq)
    {
        if ($user->canDo('mcq.mcq.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given mcq.
     *
     * @param UserPolicy $user
     * @param Mcq $mcq
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Mcq $mcq)
    {
        if ($user->canDo('mcq.mcq.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
