<?php

namespace Litecms\Mcq;

use User;

class Mcq
{
    /**
     * $mcq object.
     */
    protected $mcq;

    /**
     * Constructor.
     */
    public function __construct(\Litecms\Mcq\Interfaces\McqRepositoryInterface $mcq)
    {
        $this->mcq = $mcq;
    }

    /**
     * Returns count of mcq.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.mcq.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->mcq->pushCriteria(new \Litepie\Litecms\Repositories\Criteria\McqUserCriteria());
        }

        $mcq = $this->mcq->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('mcq::' . $view, compact('mcq'))->render();
    }
}
