<?php

namespace Litecms\Mcq\Http\Controllers;

use App\Http\Controllers\Controller as BaseController;
use Litecms\Mcq\Http\Requests\McqRequest;
use Litecms\Mcq\Models\Mcq;

/**
 * Admin web controller class.
 */
class McqWorkflowController extends BaseController
{

    /**
     * Workflow controller function for mcq.
     *
     * @param Model   $mcq
     * @param step    next step for the workflow.
     *
     * @return Response
     */

    public function putWorkflow(McqRequest $request, Mcq $mcq, $step)
    {

        try {

            $mcq->updateWorkflow($step);

            return response()->json([
                'message'  => trans('messages.success.changed', ['Module' => trans('mcq::mcq.name'), 'status' => trans("app.{$step}")]),
                'code'     => 204,
                'redirect' => trans_url('/admin/mcq/mcq/' . $mcq->getRouteKey()),
            ], 201);

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
                'redirect' => trans_url('/admin/mcq/mcq/' . $mcq->getRouteKey()),
            ], 400);

        }

    }

    /**
     * Workflow controller function for mcq.
     *
     * @param Model   $mcq
     * @param step    next step for the workflow.
     * @param user    encrypted user id.
     *
     * @return Response
     */

    public function getWorkflow(Mcq $mcq, $step, $user)
    {
        try {
            $user_id = decrypt($user);

            Auth::onceUsingId($user_id);

            $mcq->updateWorkflow($step);

            $data = [
                'message' => trans('messages.success.changed', ['Module' => trans('mcq::mcq.name'), 'status' => trans("app.{$step}")]),
                'status'  => 'success',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('mcq::admin.mcq.message', $data)->render();

        } catch (ValidationException $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b> <br /><br />' . implode('<br />', $e->validator->errors()->all()),
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('mcq::admin.mcq.message', $data)->render();

        } catch (Exception $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b>',
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('mcq::admin.mcq.message', $data)->render();

        }

    }
}
