<?php

namespace Survey\Language\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class LanguageTransformer extends TransformerAbstract
{
    public function transform(\Survey\Language\Models\Language $language)
    {
        return [
            'id'                => $language->getRouteKey(),
            'key'               => [
                'public'    => $language->getPublicKey(),
                'route'     => $language->getRouteKey(),
            ], 
            'slug'              => $language->slug,
            'name'              => $language->name,
            'country'           => $language->country,
            'details'           => $language->details,
            'icon'              => $language->icon,
            'user_id'           => $language->user_id,
            'user_type'         => $language->user_type,
            'deleted_at'        => $language->deleted_at,
            'url'               => [
                'public'    => trans_url('language/'.$language->getPublicKey()),
                'user'      => guard_url('language/language/'.$language->getRouteKey()),
            ], 
            'status'            => trans('app.'.$language->status),
            'created_at'        => format_date($language->created_at),
            'updated_at'        => format_date($language->updated_at),
        ];
    }
}