<?php

// web routes  for language
Route::prefix('{guard}/language')->group(function () {
    Route::resource('language', 'LanguageResourceController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for pages
            Route::prefix('{guard}/page')->group(function () {
                Route::apiResource('page', 'LanguageResourceController');
            });
            // Public routes for pages
            Route::get('languages/', 'LanguagePublicController@index');
            Route::get('languages/{slug?}', 'LanguagePublicController@show');
        }
    );
}

