<?php

// API routes  for language
Route::prefix('{guard}/language')->group(function () {
    Route::get('language/form/{element}', 'LanguageAPIController@form');
    Route::resource('language', 'LanguageAPIController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for languages
            Route::prefix('{guard}/language')->group(function () {
                Route::get('language/form/{element}', 'LanguageAPIController@form');
                Route::apiResource('language', 'LanguageAPIController');
            });
            // Public routes for languages
            Route::get('language/Language', 'LanguagePublicController@getLanguage');
        }
    );
}

