Lavalite package that provides language management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `survey/language`.

    "survey/language": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Survey\Language\Providers\LanguageServiceProvider::class,

And also add it to alias

    'Language'  => Survey\Language\Facades\Language::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Survey\\LanguageTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Survey\Language\Providers\LanguageServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Survey\Language\Providers\LanguageServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Survey\Language\Providers\LanguageServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/language/{modulename}

**User**

    http://path-to-route-folder/user/language/{modulename}

**Public**

    http://path-to-route-folder/languages


### API endpoints

**List**

    http://path-to-route-folder/api/user/language/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/language/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/language/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/language/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/language/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/language/{modulename}/{slug}
    METHOD: GET