# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/survey/language/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {
         ...

        "classmap": [
            ...
            
            "packages/survey/language/database/seeds",
            
            ...
        ],
        "psr-4": {
            ...
            
            "Survey\\Language\\": "packages/survey/language/src",
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Survey\Language\Providers\LanguageServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Language'  => Survey\Language\Facades\Language::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Survey\\LanguageTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Survey\Language\Providers\LanguageServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Survey\Language\Providers\LanguageServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Survey\Language\Providers\LanguageServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/language/{modulename}

**User**

    http://path-to-route-folder/user/language/{modulename}

**Public**

    http://path-to-route-folder/languages


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/language/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/language/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/language/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/language/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/language/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/language/{modulename}/{slug}
    METHOD: GET