<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateLanguagesTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: languages
         */
        Schema::create('languages', function ($table) {
            $table->increments('id');
            $table->string('slug', 255)->nullable();
            $table->string('name', 255)->nullable();
            $table->string('country', 255)->nullable();
            $table->text('details')->nullable();
            $table->text('icon')->nullable();
            $table->enum('status', ['Show','Hide'])->nullable();
            $table->integer('user_id')->nullable();
            $table->string('user_type', 100)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('languages');
    }
}
