<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'survey',

    /*
     * Package.
     */
    'package'   => 'language',

    /*
     * Modules.
     */
    'modules'   => ['language'],

    
    'language'       => [
        'model' => [
            'model'                 => \Survey\Language\Models\Language::class,
            'table'                 => 'languages',
            'presenter'             => \Survey\Language\Repositories\Presenter\LanguagePresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['id',  'slug',  'name',  'country',  'details',  'icon',  'status',  'user_id',  'user_type',  'created_at',  'updated_at',  'deleted_at'],
            'translatables'         => [],
            'upload_folder'         => 'language/language',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Survey',
            'package'   => 'Language',
            'module'    => 'Language',
        ],

    ],
];
