<?php

namespace Lavalite\Johnymap\Http\Controllers;

use App\Http\Controllers\UserController as UserController;
use Former;
use Lavalite\Johnymap\Http\Requests\CityUserRequest;
use Lavalite\Johnymap\Interfaces\CityRepositoryInterface;
use Response;
use User;

class CityUserController extends UserController
{
    /**
     * Initialize city controller.
     *
     * @param type CityRepositoryInterface $city
     *
     * @return type
     */
    public function __construct(CityRepositoryInterface $city)
    {
        $this->model = $city;
        $this->model->setUserFilter();
        parent::__construct();
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(CityUserRequest $request)
    {
        $cities = $this->model->all();

        $this->theme->prependTitle(trans('johnymap::city.names').' :: ');

        return $this->theme->of('johnymap::user.city.index', compact('cities'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function show(CityUserRequest $request, $role, $id)
    {
        $city = $this->model->find($id);

        return $this->theme->of('johnymap::user.city.show', compact('city'))->render();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(CityUserRequest $request)
    {
        $city = $this->model->findOrNew(0);

        Former::populate($city);

        return $this->theme->of('johnymap::user.city.create', compact('city'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(CityUserRequest $request)
    {
        try {
            $attributes = $request->all();
            $city = $this->model->create($attributes);

            return $this->success(trans('messages.success.created', ['Module' => trans('johnymap::city.name')]));
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function edit(CityUserRequest $request, $role, $id)
    {
        $city = $this->model->find($id);

        Former::populate($city);

        return $this->theme->of('johnymap::user.city.edit', compact('city'))->render();
    }

    /**
     * Update the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function update(CityUserRequest $request, $role, $id)
    {
        try {
            $attributes = $request->all();
            $city = $this->model->update($attributes, $id);

            return $this->success(trans('messages.success.updated', ['Module' => trans('johnymap::city.name')]));
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }

    /**
     * Remove the specified resource.
     *
     * @param int $id
     *
     * @return Response
     */
    public function destroy(CityUserRequest $request, $role, $id)
    {
        try {
            $this->model->delete($id);

            return $this->success(trans('message.success.deleted', ['Module' => trans('johnymap::city.name')]), 200);
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }
}
