<?php

namespace Lavalite\Johnymap\Http\Controllers;

use App\Http\Controllers\PublicController as CMSPublicController;
use Lavalite\Johnymap\Interfaces\CityRepositoryInterface;

class CityPublicController extends CMSPublicController
{
    /**
     * Constructor.
     *
     * @param type \Lavalite\City\Interfaces\CityRepositoryInterface $city
     *
     * @return type
     */
    public function __construct(CityRepositoryInterface $city)
    {
        $this->model = $city;
        parent::__construct();
    }

    /**
     * Show city's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $cities = $this->model->all();

        return $this->theme->of('johnymap::public.city.index', compact('cities'))->render();
    }

    /**
     * Show city.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $city = $this->model->findBySlug($slug);

        return $this->theme->of('johnymap::public.city.show', compact('city'))->render();
    }
}
