<?php

namespace Lavalite\Johnymap\Http\Controllers;

use App\Http\Controllers\AdminController as AdminController;
use Former;
use Lavalite\Johnymap\Http\Requests\CityAdminRequest;
use Lavalite\Johnymap\Interfaces\CityRepositoryInterface;
use Response;

/**
 * Admin controller class.
 */
class CityAdminController extends AdminController
{
    /**
     * Initialize city controller.
     *
     * @param type CityRepositoryInterface $city
     *
     * @return type
     */
    public function __construct(CityRepositoryInterface $city)
    {
        $this->model = $city;
        parent::__construct();
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(CityAdminRequest $request)
    {
        if ($request->wantsJson()) {
            $array = $this->model->json();
            foreach ($array as $key => $row) {
                $array[$key] = array_only($row, config('johnymap.city.listfields'));
            }

            return ['data' => $array];
        }

        $this->theme->prependTitle(trans('johnymap::city.names').' :: ');

        return $this->theme->of('johnymap::admin.city.index')->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function show(CityAdminRequest $request, $id)
    {
        $city = $this->model->find($id);

        if (empty($city)) {
            if ($request->wantsJson()) {
                return [];
            }

            return view('johnymap::admin.city.new');
        }

        if ($request->wantsJson()) {
            return $city;
        }

        Former::populate($city);

        return view('johnymap::admin.city.show', compact('city'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(CityAdminRequest $request)
    {
        $city = $this->model->findOrNew(0);
        Former::populate($city);

        return view('johnymap::admin.city.create', compact('city'));
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(CityAdminRequest $request)
    {
        try {
            $attributes = $request->all();
            $city = $this->model->create($attributes);

            return $this->success(trans('messages.success.created', ['Module' => trans('johnymap::city.name')]));
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function edit(CityAdminRequest $request, $id)
    {
        $city = $this->model->find($id);

        Former::populate($city);

        return view('johnymap::admin.city.edit', compact('city'));
    }

    /**
     * Update the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function update(CityAdminRequest $request, $id)
    {
        try {
            $attributes = $request->all();
            $city = $this->model->update($attributes, $id);

            return $this->success(trans('messages.success.updated', ['Module' => trans('johnymap::city.name')]));
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }

    /**
     * Remove the specified resource.
     *
     * @param int $id
     *
     * @return Response
     */
    public function destroy(CityAdminRequest $request, $id)
    {
        try {
            $this->model->delete($id);

            return $this->success(trans('message.success.deleted', ['Module' => trans('johnymap::city.name')]), 200);
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }
}
