<?php

namespace Litecms\Form\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class FormTransformer extends TransformerAbstract
{
    public function transform(\Litecms\Form\Models\Form $form)
    {
        return [
            'id'                => $form->getRouteKey(),
            'key'               => [
                'public'    => $form->getPublicKey(),
                'route'     => $form->getRouteKey(),
            ], 
            'id'                => $form->id,
            'name'              => $form->name,
            'address'           => $form->address,
            'phone'             => $form->phone,
            'slug'              => $form->slug,
            'status'            => $form->status,
            'userid'            => $form->userid,
            'deleted_at'        => $form->deleted_at,
            'created_at'        => $form->created_at,
            'updated_at'        => $form->updated_at,
            'url'               => [
                'public'    => trans_url('form/'.$form->getPublicKey()),
                'user'      => guard_url('form/form/'.$form->getRouteKey()),
            ], 
            'status'            => trans('app.'.$form->status),
            'created_at'        => format_date($form->created_at),
            'updated_at'        => format_date($form->updated_at),
        ];
    }
}