<?php

namespace Litecms\Form\Providers;

use Illuminate\Support\ServiceProvider;

class FormServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'form');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'form');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('litecms.form', function ($app) {
            return $this->app->make('Litecms\Form\Form');
        });

                // Bind Form to repository
        $this->app->bind(
            'Litecms\Form\Interfaces\FormRepositoryInterface',
            \Litecms\Form\Repositories\Eloquent\FormRepository::class
        );

        $this->app->register(\Litecms\Form\Providers\AuthServiceProvider::class);
                $this->app->register(\Litecms\Form\Providers\EventServiceProvider::class);
        
        $this->app->register(\Litecms\Form\Providers\RouteServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.form'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('litecms/form.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/form')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/form')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
