<?php

namespace Litecms\Form\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\Form\Models\Form;

class FormPolicy
{

    /**
     * Determine if the given user can view the form.
     *
     * @param UserPolicy $user
     * @param Form $form
     *
     * @return bool
     */
    public function view(UserPolicy $user, Form $form)
    {
        if ($user->canDo('form.form.view') && $user->isAdmin()) {
            return true;
        }

        return $form->user_id == user_id() && $form->user_type == user_type();
    }

    /**
     * Determine if the given user can create a form.
     *
     * @param UserPolicy $user
     * @param Form $form
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('form.form.create');
    }

    /**
     * Determine if the given user can update the given form.
     *
     * @param UserPolicy $user
     * @param Form $form
     *
     * @return bool
     */
    public function update(UserPolicy $user, Form $form)
    {
        if ($user->canDo('form.form.edit') && $user->isAdmin()) {
            return true;
        }

        return $form->user_id == user_id() && $form->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given form.
     *
     * @param UserPolicy $user
     * @param Form $form
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Form $form)
    {
        return $form->user_id == user_id() && $form->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given form.
     *
     * @param UserPolicy $user
     * @param Form $form
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Form $form)
    {
        if ($user->canDo('form.form.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given form.
     *
     * @param UserPolicy $user
     * @param Form $form
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Form $form)
    {
        if ($user->canDo('form.form.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
