<?php

namespace Litecms\Form\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Litecms\Form\Interfaces\FormRepositoryInterface;

class FormPublicController extends BaseController
{
    // use FormWorkflow;

    /**
     * Constructor.
     *
     * @param type \Litecms\Form\Interfaces\FormRepositoryInterface $form
     *
     * @return type
     */
    public function __construct(FormRepositoryInterface $form)
    {
        $this->repository = $form;
        parent::__construct();
    }

    /**
     * Show form's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $forms = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$form::$form.names'))
            ->view('$form::public.form.index')
            ->data(compact('$forms'))
            ->output();
    }

    /**
     * Show form's list based on a type.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function list($type = null)
    {
        $forms = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$form::$form.names'))
            ->view('$form::public.form.index')
            ->data(compact('$forms'))
            ->output();
    }

    /**
     * Show form.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $form = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->title($$form->name . trans('$form::$form.name'))
            ->view('$form::public.form.show')
            ->data(compact('$form'))
            ->output();
    }

}
