Lavalite package that provides elenamax management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `elenamax/elenamax`.

    "elenamax/elenamax": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Elenamax\Elenamax\Providers\ElenamaxServiceProvider::class,

And also add it to alias

    'Elenamax'  => Elenamax\Elenamax\Facades\Elenamax::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Elenamax\\Elenamax\\Seeders\\ElenamaxTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Elenamax\Elenamax\Providers\ElenamaxServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Elenamax\Elenamax\Providers\ElenamaxServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Elenamax\Elenamax\Providers\ElenamaxServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/elenamax/{modulename}

**User**

    http://path-to-route-folder/user/elenamax/{modulename}

**Public**

    http://path-to-route-folder/elenamaxes


### API endpoints

**List**

    http://path-to-route-folder/api/user/elenamax/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/elenamax/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/elenamax/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/elenamax/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/elenamax/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/elenamax/{modulename}/{slug}
    METHOD: GET