# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/elenamax/elenamax/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Elenamax\\Elenamax\\": "packages/elenamax/elenamax/src",
            "Elenamax\\Elenamax\\Seeders\\": "packages/elenamax/elenamax/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Elenamax\Elenamax\Providers\ElenamaxServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Elenamax'  => Elenamax\Elenamax\Facades\Elenamax::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Elenamax\\Elenamax\\Seeders\\ElenamaxTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Elenamax\Elenamax\Providers\ElenamaxServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Elenamax\Elenamax\Providers\ElenamaxServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Elenamax\Elenamax\Providers\ElenamaxServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/elenamax/{modulename}

**User**

    http://path-to-route-folder/user/elenamax/{modulename}

**Public**

    http://path-to-route-folder/elenamaxes


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/elenamax/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/elenamax/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/elenamax/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/elenamax/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/elenamax/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/elenamax/{modulename}/{slug}
    METHOD: GET