<?php

namespace Bixo\Demo\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class UserTransformer extends TransformerAbstract
{
    public function transform(\Bixo\Demo\Models\User $user)
    {
        return [
            'id'                => $user->getRouteKey(),
            'key'               => [
                'public'    => $user->getPublicKey(),
                'route'     => $user->getRouteKey(),
            ], 
            'reporting_to'      => $user->reporting_to,
            'name'              => $user->name,
            'email'             => $user->email,
            'password'          => $user->password,
            'api_token'         => $user->api_token,
            'remember_token'    => $user->remember_token,
            'sex'               => $user->sex,
            'dob'               => $user->dob,
            'doj'               => $user->doj,
            'designation'       => $user->designation,
            'description'       => $user->description,
            'mobile'            => $user->mobile,
            'phone'             => $user->phone,
            'address'           => $user->address,
            'street'            => $user->street,
            'city'              => $user->city,
            'district'          => $user->district,
            'state'             => $user->state,
            'country'           => $user->country,
            'photo'             => $user->photo,
            'web'               => $user->web,
            'urls'              => $user->urls,
            'email_verified_at' => $user->email_verified_at,
            'user_id'           => $user->user_id,
            'user_type'         => $user->user_type,
            'upload_folder'     => $user->upload_folder,
            'deleted_at'        => $user->deleted_at,
            'team_id'           => $user->team_id,
            'url'               => [
                'public'    => trans_url('demo/'.$user->getPublicKey()),
                'user'      => guard_url('demo/user/'.$user->getRouteKey()),
            ], 
            'status'            => trans('app.'.$user->status),
            'created_at'        => format_date($user->created_at),
            'updated_at'        => format_date($user->updated_at),
        ];
    }
}