<?php

namespace Bixo\Demo\Policies;

use Litepie\User\Contracts\UserPolicy;
use Bixo\Demo\Models\User;

class UserPolicy
{

    /**
     * Determine if the given user can view the user.
     *
     * @param UserPolicy $user
     * @param User $user
     *
     * @return bool
     */
    public function view(UserPolicy $user, User $user)
    {
        if ($user->canDo('demo.user.view') && $user->isAdmin()) {
            return true;
        }

        return $user->user_id == user_id() && $user->user_type == user_type();
    }

    /**
     * Determine if the given user can create a user.
     *
     * @param UserPolicy $user
     * @param User $user
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('demo.user.create');
    }

    /**
     * Determine if the given user can update the given user.
     *
     * @param UserPolicy $user
     * @param User $user
     *
     * @return bool
     */
    public function update(UserPolicy $user, User $user)
    {
        if ($user->canDo('demo.user.edit') && $user->isAdmin()) {
            return true;
        }

        return $user->user_id == user_id() && $user->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given user.
     *
     * @param UserPolicy $user
     * @param User $user
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, User $user)
    {
        return $user->user_id == user_id() && $user->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given user.
     *
     * @param UserPolicy $user
     * @param User $user
     *
     * @return bool
     */
    public function verify(UserPolicy $user, User $user)
    {
        if ($user->canDo('demo.user.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given user.
     *
     * @param UserPolicy $user
     * @param User $user
     *
     * @return bool
     */
    public function approve(UserPolicy $user, User $user)
    {
        if ($user->canDo('demo.user.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
