<?php

namespace Bixo\Demo\Forms;

class User
{
    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $form;

    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $element;

    /**
     * Initialize the form.
     *
     * @return null
     */
    public function __construct()
    {
        $this->setForm();
    }

    /**
     * Return form elements.
     *
     * @return array.
     */
    public function form($element = 'fields', $grouped = true)
    {
        $item = collect($this->form->get($element));
        if ($element == 'fields' && $grouped == true) {
            return $item->groupBy(['group', 'section']);
        }
        return $item;

    }

    /**
     * Sets the form and form elements.
     * @return null.
     */
    public function setForm()
    {
        $this->form = collect([
            'form' => [
                'store' => [],
                'update' => [],
            ],
            'groups' => [
                'main' => 'Main',
            ],
            'fields' => [
                'reporting_to' => [
                    "type" => 'numeric',
                    "label" => trans('demo::user.label.reporting_to'),
                    "placeholder" => trans('demo::user.placeholder.reporting_to'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'name' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.name'),
                    "placeholder" => trans('demo::user.placeholder.name'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'email' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.email'),
                    "placeholder" => trans('demo::user.placeholder.email'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'password' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.password'),
                    "placeholder" => trans('demo::user.placeholder.password'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'api_token' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.api_token'),
                    "placeholder" => trans('demo::user.placeholder.api_token'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'remember_token' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.remember_token'),
                    "placeholder" => trans('demo::user.placeholder.remember_token'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'sex' => [
                    "type" => 'radios',
                    "label" => trans('demo::user.label.sex'),
                    "placeholder" => trans('demo::user.placeholder.sex'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'dob' => [
                    "type" => 'date_picker',
                    "label" => trans('demo::user.label.dob'),
                    "placeholder" => trans('demo::user.placeholder.dob'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'doj' => [
                    "type" => 'date_picker',
                    "label" => trans('demo::user.label.doj'),
                    "placeholder" => trans('demo::user.placeholder.doj'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'designation' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.designation'),
                    "placeholder" => trans('demo::user.placeholder.designation'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'description' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.description'),
                    "placeholder" => trans('demo::user.placeholder.description'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'mobile' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.mobile'),
                    "placeholder" => trans('demo::user.placeholder.mobile'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'phone' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.phone'),
                    "placeholder" => trans('demo::user.placeholder.phone'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'address' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.address'),
                    "placeholder" => trans('demo::user.placeholder.address'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'street' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.street'),
                    "placeholder" => trans('demo::user.placeholder.street'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'city' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.city'),
                    "placeholder" => trans('demo::user.placeholder.city'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'district' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.district'),
                    "placeholder" => trans('demo::user.placeholder.district'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'state' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.state'),
                    "placeholder" => trans('demo::user.placeholder.state'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'country' => [
                    "type" => 'numeric',
                    "label" => trans('demo::user.label.country'),
                    "placeholder" => trans('demo::user.placeholder.country'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'photo' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.photo'),
                    "placeholder" => trans('demo::user.placeholder.photo'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'web' => [
                    "type" => 'text',
                    "label" => trans('demo::user.label.web'),
                    "placeholder" => trans('demo::user.placeholder.web'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'urls' => [
                    "type" => 'html_editor',
                    "label" => trans('demo::user.label.urls'),
                    "placeholder" => trans('demo::user.placeholder.urls'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'email_verified_at' => [
                    "type" => 'date_time_picker',
                    "label" => trans('demo::user.label.email_verified_at'),
                    "placeholder" => trans('demo::user.placeholder.email_verified_at'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'team_id' => [
                    "type" => 'numeric',
                    "label" => trans('demo::user.label.team_id'),
                    "placeholder" => trans('demo::user.placeholder.team_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
            ]
        );

    }
}
