<?php

namespace Bixo\Demo;

use User;

class Demo
{
    /**
     * $user object.
     */
    protected $user;

    /**
     * Constructor.
     */
    public function __construct(\Bixo\Demo\Interfaces\UserRepositoryInterface $user)
    {
        $this->user = $user;
    }

    /**
     * Returns count of demo.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.user.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->user->pushCriteria(new \Litepie\Bixo\Repositories\Criteria\UserUserCriteria());
        }

        $user = $this->user->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('demo::' . $view, compact('user'))->render();
    }
}
