<?php

// web routes  for user
Route::prefix('{guard}/demo')->group(function () {
    Route::resource('user', 'UserResourceController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for pages
            Route::prefix('{guard}/page')->group(function () {
                Route::apiResource('page', 'UserResourceController');
            });
            // Public routes for pages
            Route::get('demos/', 'UserPublicController@index');
            Route::get('demos/{slug?}', 'UserPublicController@show');
        }
    );
}

