<?php

// API routes  for user
Route::prefix('{guard}/demo')->group(function () {
    Route::get('user/form/{element}', 'UserAPIController@form');
    Route::resource('user', 'UserAPIController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for demos
            Route::prefix('{guard}/demo')->group(function () {
                Route::get('user/form/{element}', 'UserAPIController@form');
                Route::apiResource('user', 'UserAPIController');
            });
            // Public routes for demos
            Route::get('demo/User', 'UserPublicController@getUser');
        }
    );
}

