<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-file-text-o"></i> {!! trans('demo::user.name') !!} <small> {!! trans('app.manage') !!} {!! trans('demo::user.names') !!}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{!! guard_url('/') !!}"><i class="fa fa-dashboard"></i> {!! trans('app.home') !!} </a></li>
            <li class="active">{!! trans('demo::user.names') !!}</li>
        </ol>
    </section>
    <!-- Main content -->
    <section class="content">
    <div id='demo-user-entry'>
    </div>
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                    <li class="{!!(request('status') == '')?'active':'';!!}"><a href="{!!guard_url('demo/user')!!}">{!! trans('demo::user.names') !!}</a></li>
                    <li class="{!!(request('status') == 'archive')?'active':'';!!}"><a href="{!!guard_url('demo/user?status=archive')!!}">Archived</a></li>
                    <li class="{!!(request('status') == 'deleted')?'active':'';!!}"><a href="{!!guard_url('demo/user?status=deleted')!!}">Trashed</a></li>
                    <li class="pull-right">
                    <span class="actions">
                    <!--   
                    <a  class="btn btn-xs btn-purple"  href="{!!guard_url('demo/user/reports')!!}"><i class="fa fa-bar-chart" aria-hidden="true"></i><span class="hidden-sm hidden-xs"> Reports</span></a>
                    @include('demo::admin.user.partial.actions')
                    -->
                    @include('demo::admin.user.partial.filter')
                    @include('demo::admin.user.partial.column')
                    </span> 
                </li>
            </ul>
            <div class="tab-content">
                <table id="demo-user-list" class="table table-striped data-table">
                    <thead class="list_head">
                        <th style="text-align: right;" width="1%"><a class="btn-reset-filter" href="#Reset" style="display:none; color:#fff;"><i class="fa fa-filter"></i></a> <input type="checkbox" id="demo-user-check-all"></th>
                        <th data-field="reporting_to">{!! trans('demo::user.label.reporting_to')!!}</th>
                    <th data-field="name">{!! trans('demo::user.label.name')!!}</th>
                    <th data-field="email">{!! trans('demo::user.label.email')!!}</th>
                    <th data-field="password">{!! trans('demo::user.label.password')!!}</th>
                    <th data-field="api_token">{!! trans('demo::user.label.api_token')!!}</th>
                    <th data-field="remember_token">{!! trans('demo::user.label.remember_token')!!}</th>
                    <th data-field="sex">{!! trans('demo::user.label.sex')!!}</th>
                    <th data-field="dob">{!! trans('demo::user.label.dob')!!}</th>
                    <th data-field="doj">{!! trans('demo::user.label.doj')!!}</th>
                    <th data-field="designation">{!! trans('demo::user.label.designation')!!}</th>
                    <th data-field="description">{!! trans('demo::user.label.description')!!}</th>
                    <th data-field="mobile">{!! trans('demo::user.label.mobile')!!}</th>
                    <th data-field="phone">{!! trans('demo::user.label.phone')!!}</th>
                    <th data-field="address">{!! trans('demo::user.label.address')!!}</th>
                    <th data-field="street">{!! trans('demo::user.label.street')!!}</th>
                    <th data-field="city">{!! trans('demo::user.label.city')!!}</th>
                    <th data-field="district">{!! trans('demo::user.label.district')!!}</th>
                    <th data-field="state">{!! trans('demo::user.label.state')!!}</th>
                    <th data-field="country">{!! trans('demo::user.label.country')!!}</th>
                    <th data-field="photo">{!! trans('demo::user.label.photo')!!}</th>
                    <th data-field="web">{!! trans('demo::user.label.web')!!}</th>
                    <th data-field="email_verified_at">{!! trans('demo::user.label.email_verified_at')!!}</th>
                    <th data-field="team_id">{!! trans('demo::user.label.team_id')!!}</th>
                    </thead>
                </table>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">

var oTable;
var oSearch;
$(document).ready(function(){
    app.load('#demo-user-entry', '{!!guard_url('demo/user/0')!!}');
    oTable = $('#demo-user-list').dataTable( {
        'columnDefs': [{
            'targets': 0,
            'searchable': false,
            'orderable': false,
            'className': 'dt-body-center',
            'render': function (data, type, full, meta){
                return '<input type="checkbox" name="id[]" value="' + data.id + '">';
            }
        }], 
        
        "responsive" : true,
        "order": [[1, 'asc']],
        "bProcessing": true,
        "sDom": 'R<>rt<ilp><"clear">',
        "bServerSide": true,
        "sAjaxSource": '{!! guard_url('demo/user') !!}',
        "fnServerData" : function ( sSource, aoData, fnCallback ) {

            $.each(oSearch, function(key, val){
                aoData.push( { 'name' : key, 'value' : val } );
            });
            app.dataTable(aoData);
            $.ajax({
                'dataType'  : 'json',
                'data'      : aoData,
                'type'      : 'GET',
                'url'       : sSource,
                'success'   : fnCallback
            });
        },

        "columns": [
            {data :'id'},
            {data :'reporting_to'},
            {data :'name'},
            {data :'email'},
            {data :'password'},
            {data :'api_token'},
            {data :'remember_token'},
            {data :'sex'},
            {data :'dob'},
            {data :'doj'},
            {data :'designation'},
            {data :'description'},
            {data :'mobile'},
            {data :'phone'},
            {data :'address'},
            {data :'street'},
            {data :'city'},
            {data :'district'},
            {data :'state'},
            {data :'country'},
            {data :'photo'},
            {data :'web'},
            {data :'email_verified_at'},
            {data :'team_id'},
        ],
        "pageLength": 25
    });

    $('#demo-user-list tbody').on( 'click', 'tr', function () {
        oTable.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        var d = $('#demo-user-list').DataTable().row( this ).data();
        $('#demo-user-entry').load('{!!guard_url('demo/user')!!}' + '/' + d.id);
    });

    $('#demo-user-list tbody').on( 'change', "input[name^='id[]']", function (e) {
        e.preventDefault();

        aIds = [];
        $(".child").remove();
        $(this).parent().parent().removeClass('parent'); 
        $("input[name^='id[]']:checked").each(function(){
            aIds.push($(this).val());
        });
    });

    $("#demo-user-check-all").on( 'change', function (e) {
        e.preventDefault();
        aIds = [];
        if ($(this).prop('checked')) {
            $("input[name^='id[]']").each(function(){
                $(this).prop('checked',true);
                aIds.push($(this).val());
            });

            return;
        }else{
            $("input[name^='id[]']").prop('checked',false);
        }
        
    });


    $(".reset_filter").click(function (e) {
        e.preventDefault();
        $("#form-search")[ 0 ].reset();
        $('#form-search input,#form-search select').each( function () {
          oTable.search( this.value ).draw();
        });
        $('#demo-user-list .reset_filter').css('display', 'none');

    });


    // Add event listener for opening and closing details
    $('#demo-user-list tbody').on('click', 'td.details-control', function (e) {
        e.preventDefault();
        var tr = $(this).closest('tr');
        var row = table.row( tr );
 
        if ( row.child.isShown() ) {
            // This row is already open - close it
            row.child.hide();
            tr.removeClass('shown');
        } else {
            // Open this row
            row.child( format(row.data()) ).show();
            tr.addClass('shown');
        }
    });

});
</script>