Lavalite package that provides demo management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `bixo/demo`.

    "bixo/demo": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Bixo\Demo\Providers\DemoServiceProvider::class,

And also add it to alias

    'Demo'  => Bixo\Demo\Facades\Demo::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Bixo\\DemoTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Bixo\Demo\Providers\DemoServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Bixo\Demo\Providers\DemoServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Bixo\Demo\Providers\DemoServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/demo/{modulename}

**User**

    http://path-to-route-folder/user/demo/{modulename}

**Public**

    http://path-to-route-folder/demos


### API endpoints

**List**

    http://path-to-route-folder/api/user/demo/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/demo/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/demo/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/demo/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/demo/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/demo/{modulename}/{slug}
    METHOD: GET