# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/bixo/demo/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {
         ...

        "classmap": [
            ...
            
            "packages/bixo/demo/database/seeds",
            
            ...
        ],
        "psr-4": {
            ...
            
            "Bixo\\Demo\\": "packages/bixo/demo/src",
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Bixo\Demo\Providers\DemoServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Demo'  => Bixo\Demo\Facades\Demo::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Bixo\\DemoTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Bixo\Demo\Providers\DemoServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Bixo\Demo\Providers\DemoServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Bixo\Demo\Providers\DemoServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/demo/{modulename}

**User**

    http://path-to-route-folder/user/demo/{modulename}

**Public**

    http://path-to-route-folder/demos


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/demo/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/demo/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/demo/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/demo/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/demo/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/demo/{modulename}/{slug}
    METHOD: GET