<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'bixo',

    /*
     * Package.
     */
    'package'   => 'demo',

    /*
     * Modules.
     */
    'modules'   => ['user'],

    
    'user'       => [
        'model' => [
            'model'                 => \Bixo\Demo\Models\User::class,
            'table'                 => 'users',
            'presenter'             => \Bixo\Demo\Repositories\Presenter\UserPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['id',  'reporting_to',  'name',  'email',  'password',  'api_token',  'remember_token',  'sex',  'dob',  'doj',  'designation',  'description',  'mobile',  'phone',  'address',  'street',  'city',  'district',  'state',  'country',  'photo',  'web',  'urls',  'status',  'email_verified_at',  'user_id',  'user_type',  'upload_folder',  'deleted_at',  'created_at',  'updated_at',  'team_id'],
            'translatables'         => [],
            'upload_folder'         => 'demo/user',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Bixo',
            'package'   => 'Demo',
            'module'    => 'User',
        ],

    ],
];
