<?php

namespace Btravel\Comment\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class CommentTransformer extends TransformerAbstract
{
    public function transform(\Btravel\Comment\Models\Comment $comment)
    {
        return [
            'id'                => $comment->getRouteKey(),
            'key'               => [
                'public'    => $comment->getPublicKey(),
                'route'     => $comment->getRouteKey(),
            ], 
            'id'                => $comment->id,
            'user_id'           => $comment->user_id,
            'object_id'         => $comment->object_id,
            'comment'           => $comment->comment,
            'images'            => $comment->images,
            'status'            => $comment->status,
            'slug'              => $comment->slug,
            'user_type'         => $comment->user_type,
            'created_at'        => $comment->created_at,
            'updated_at'        => $comment->updated_at,
            'deleted_at'        => $comment->deleted_at,
            'url'               => [
                'public'    => trans_url('comment/'.$comment->getPublicKey()),
                'user'      => guard_url('comment/comment/'.$comment->getRouteKey()),
            ], 
            'status'            => trans('app.'.$comment->status),
            'created_at'        => format_date($comment->created_at),
            'updated_at'        => format_date($comment->updated_at),
        ];
    }
}