<?php

namespace Btravel\Comment\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Btravel\Comment\Interfaces\CommentRepositoryInterface;

class CommentPublicController extends BaseController
{
    // use CommentWorkflow;

    /**
     * Constructor.
     *
     * @param type \Btravel\Comment\Interfaces\CommentRepositoryInterface $comment
     *
     * @return type
     */
    public function __construct(CommentRepositoryInterface $comment)
    {
        $this->repository = $comment;
        parent::__construct();
    }

    /**
     * Show comment's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $comments = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->setMetaTitle(trans('$comment::comment.names'))
            ->view('comment::comment.index')
            ->data(compact('comments'))
            ->output();
    }


    /**
     * Show comment.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $comment = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->setMetaTitle($$comment->name . trans('comment::comment.name'))
            ->view('comment::comment.show')
            ->data(compact('comment'))
            ->output();
    }

}
