<?php

namespace Btravel\Comment;

use User;

class Comment
{
    /**
     * $comment object.
     */
    protected $comment;

    /**
     * Constructor.
     */
    public function __construct(\Btravel\Comment\Interfaces\CommentRepositoryInterface $comment)
    {
        $this->comment = $comment;
    }

    /**
     * Returns count of comment.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.comment.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->comment->pushCriteria(new \Litepie\Btravel\Repositories\Criteria\CommentUserCriteria());
        }

        $comment = $this->comment->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('comment::' . $view, compact('comment'))->render();
    }
}
