<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Language files for comment in comment package
    |--------------------------------------------------------------------------
    |
    | The following language lines are  for  comment module in comment package
    | and it is used by the template/view files in this module
    |
    */

    /**
     * Singlular and plural name of the module
     */
    'name'          => 'Comment',
    'names'         => 'Comments',
    
    /**
     * Singlular and plural name of the module
     */
    'title'         => [
        'main'  => 'Comments',
        'sub'   => 'Comments',
        'list'  => 'List of comments',
        'edit'  => 'Edit comment',
        'create'    => 'Create new comment'
    ],

    /**
     * Options for select/radio/check.
     */
    'options'       => [
            'status'              => ['Online','Offline'],
    ],

    /**
     * Placeholder for inputs
     */
    'placeholder'   => [
        'id'                         => 'Please enter id',
        'user_id'                    => 'Please enter user id',
        'object_id'                  => 'Please enter object id',
        'comment'                    => 'Please enter comment',
        'images'                     => 'Please enter images',
        'status'                     => 'Please select status',
        'slug'                       => 'Please enter slug',
        'user_type'                  => 'Please enter user type',
        'created_at'                 => 'Please select created at',
        'updated_at'                 => 'Please select updated at',
        'deleted_at'                 => 'Please select deleted at',
    ],

    /**
     * Labels for inputs.
     */
    'label'         => [
        'id'                         => 'Id',
        'user_id'                    => 'User id',
        'object_id'                  => 'Object id',
        'comment'                    => 'Comment',
        'images'                     => 'Images',
        'status'                     => 'Status',
        'slug'                       => 'Slug',
        'user_type'                  => 'User type',
        'created_at'                 => 'Created at',
        'updated_at'                 => 'Updated at',
        'deleted_at'                 => 'Deleted at',
    ],

    /**
     * Columns array for show hide checkbox.
     */
    'cloumns'         => [
        'user_id'                    => ['name' => 'User id', 'data-column' => 1, 'checked'],
        'object_id'                  => ['name' => 'Object id', 'data-column' => 2, 'checked'],
        'comment'                    => ['name' => 'Comment', 'data-column' => 3, 'checked'],
        'images'                     => ['name' => 'Images', 'data-column' => 4, 'checked'],
        'status'                     => ['name' => 'Status', 'data-column' => 5, 'checked'],
        'created_at'                 => ['name' => 'Created at', 'data-column' => 6, 'checked'],
    ],

    /**
     * Tab labels
     */
    'tab'           => [
        'name'  => 'Comments',
    ],

    /**
     * Texts  for the module
     */
    'text'          => [
        'preview' => 'Click on the below list for preview',
    ],
];
