<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: comments
         */
        Schema::create('comments', function ($table) {
            $table->increments('id');
            $table->string('user_id', 30)->nullable();
            $table->integer('object_id')->nullable();
            $table->text('comment')->nullable();
            $table->text('images')->nullable();
            $table->enum('status', ['Online','Offline'])->nullable();
            $table->text('slug')->nullable();
            $table->string('user_type', 225)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('comments');
    }
}
