<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'btravel',

    /*
     * Package.
     */
    'package'   => 'comment',

    /*
     * Modules.
     */
    'modules'   => ['comment'],

    
    'comment'       => [
        'model' => [
            'model'                 => \Btravel\Comment\Models\Comment::class,
            'table'                 => 'comments',
            'presenter'             => \Btravel\Comment\Repositories\Presenter\CommentPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['id',  'user_id',  'object_id',  'comment',  'images',  'status',  'slug',  'user_type',  'created_at',  'updated_at',  'deleted_at'],
            'translatables'         => [],
            'upload_folder'         => 'comment/comment',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Btravel',
            'package'   => 'Comment',
            'module'    => 'Comment',
        ],

    ],
];
