Lavalite package that provides general management facility for the cms.

## Installation

Run the below command form the root folder of lavalite.

```
    composer require "microsoft/general"
```


## Migration and seeds

```
    php artisan migrate
    php artisan db:seed --class=Microsoft\\General\\Seeders\\GeneralTableSeeder
```

## Publishing

* Configuration
```
    php artisan vendor:publish --provider="Microsoft\General\Providers\GeneralServiceProvider" --tag="config"
```
* Language
```
    php artisan vendor:publish --provider="Microsoft\General\Providers\GeneralServiceProvider" --tag="lang"
```
* Views
```
    php artisan vendor:publish --provider="Microsoft\General\Providers\GeneralServiceProvider" --tag="view"
```


## URLs and APIs


### Web Urls

* Admin
```
    http://path-to-route-folder/admin/general/{modulename}
```

* User
```
    http://path-to-route-folder/user/general/{modulename}
```

* Public
```
    http://path-to-route-folder/generals
```


### API endpoints

These endpoints can be used with or without `/api/`
And also the user can be varied depend on the type of users, eg user, client, admin etc.

#### Resource

* List
```
    http://path-to-route-folder/api/user/general/{modulename}
    METHOD: GET
```

* Create
```
    http://path-to-route-folder/api/user/general/{modulename}
    METHOD: POST
```

* Edit
```
    http://path-to-route-folder/api/user/general/{modulename}/{id}
    METHOD: PUT
```

* Delete
```
    http://path-to-route-folder/api/user/general/{modulename}/{id}
    METHOD: DELETE
```

#### Public

* List
```
    http://path-to-route-folder/api/general/{modulename}
    METHOD: GET
```

* Single Item
```
    http://path-to-route-folder/api/general/{modulename}/{slug}
    METHOD: GET
```

#### Others

* Report
```
    http://path-to-route-folder/api/user/general/{modulename}/report/{report}
    METHOD: GET
```

* Export/Import
```
    http://path-to-route-folder/api/user/general/{modulename}/exim/{exim}
    METHOD: POST
```

* Action
```
    http://path-to-route-folder/api/user/general/{modulename}/action/{id}/{action}
    METHOD: PATCH
```

* Actions
```
    http://path-to-route-folder/api/user/general/{modulename}/actions/{action}
    METHOD: PATCH
```

* Workflow
```
    http://path-to-route-folder/api/user/general/{modulename}/workflow/{id}/{transition}
    METHOD: PATCH
```
