<?php

namespace Litecms\Blog\Providers;

use Illuminate\Support\ServiceProvider;
use Litecms\Blog\Blogs;

class BlogServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'blog');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'blog');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerFacade();

        $this->app->register(\Litecms\Blog\Providers\AuthServiceProvider::class);
        $this->app->register(\Litecms\Blog\Providers\RouteServiceProvider::class);
        $this->app->register(\Litecms\Blog\Providers\WorkflowServiceProvider::class);
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->bind('litecms.blog', function($app)
        {
            return $this->app->make(Blog::class);
        });
    }

    /**
     * Merges user's and blog's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'litecms.blog'
        );
        
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/blog.php', 'litecms.blog.blog'
        );
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/category.php', 'litecms.blog.category'
        );
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/tag.php', 'litecms.blog.tag'
        );
    }


    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.blog'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/' => config_path('litecms/blog')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/blog')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/blog')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
