<?php

namespace Litecms\Blog\Policies;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Litecms\Blog\Models\Tag;

class TagPolicy
{


    /**
     * Determine if the given user can view the tag.
     *
     * @param Authenticatable $user
     * @param Tag $tag
     *
     * @return bool
     */
    public function view(Authenticatable $user, Tag $tag)
    {
        if ($authUser->canDo('blog.tag.view') && $authUser->isAdmin() || $user->isClient()) {
            return true;
        }

        return $tag->is_owner;
    }

    /**
     * Determine if the given user can create a tag.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function create(Authenticatable $user)
    {
        return  $authUser->canDo('blog.tag.create');
    }

    /**
     * Determine if the given user can update the given tag.
     *
     * @param Authenticatable $user
     * @param Tag $tag
     *
     * @return bool
     */
    public function update(Authenticatable $user, Tag $tag)
    {
        if ($user->canDo('blog.tag.edit') && $user->isAdmin()) {
            return true;
        }

        return $tag->is_owner;
    }

    /**
     * Determine if the given user can delete the given tag.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function destroy(Authenticatable $user, Tag $tag)
    {
        return $tag->is_owner;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
