<?php

namespace Litecms\Blog\Policies;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Litecms\Blog\Models\Category;

class CategoryPolicy
{


    /**
     * Determine if the given user can view the category.
     *
     * @param Authenticatable $user
     * @param Category $category
     *
     * @return bool
     */
    public function view(Authenticatable $user, Category $category)
    {
        if ($authUser->canDo('blog.category.view') && $authUser->isAdmin() || $user->isClient()) {
            return true;
        }

        return $category->is_owner;
    }

    /**
     * Determine if the given user can create a category.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function create(Authenticatable $user)
    {
        return  $authUser->canDo('blog.category.create');
    }

    /**
     * Determine if the given user can update the given category.
     *
     * @param Authenticatable $user
     * @param Category $category
     *
     * @return bool
     */
    public function update(Authenticatable $user, Category $category)
    {
        if ($user->canDo('blog.category.edit') && $user->isAdmin()) {
            return true;
        }

        return $category->is_owner;
    }

    /**
     * Determine if the given user can delete the given category.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function destroy(Authenticatable $user, Category $category)
    {
        return $category->is_owner;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
