<?php

namespace Litecms\Blog\Policies;

use Litecms\Blog\Models\Blog;
use Illuminate\Foundation\Auth\User as Authenticatable;

trait BlogWorkflow
{

    /**
     * Determine if the given user can approve the given blog.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function approve(Authenticatable $user, Blog $blog)
    {
        if ($user->canDo('blog.blog.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given blog.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function submit(Authenticatable $user, Blog $blog)
    {
        if ($user->canDo('blog.blog.submit')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given blog.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function publish(Authenticatable $user, Blog $blog)
    {
        if ($user->canDo('blog.blog.publish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given blog.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function unpublish(Authenticatable $user, Blog $blog)
    {
        if ($user->canDo('blog.blog.unpublish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given blog.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function archive(Authenticatable $user, Blog $blog)
    {
        if ($user->canDo('blog.blog.archive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given blog.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function unarchive(Authenticatable $user, Blog $blog)
    {
        if ($user->canDo('blog.blog.unarchive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given blog.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function reject(Authenticatable $user, Blog $blog)
    {
        if ($user->canDo('blog.blog.reject')) {
            return true;
        }

        return false;
    }

}
